/* This program removes utmp entries by name or number */



#include <utmp.h>

#include <stdio.h>

#include <sys/file.h>

#include <sys/fcntlcom.h>



void usage(name)

char *name;

{

    printf(stdout, "Usage: %s [ user ] or [ tty ]\n", name);

    exit(1);

}



main(int argc, char **argv)

{

    int fd;

    struct utmp utmp;

    int size;

    int match, tty = 0;



    if (argc!=2)

       usage(argv[0]);



    if ( !strncmp(argv[1],"tty",3) )

       tty++;



    fd = open("/etc/utmp",O_RDWR);

    if (fd >= 0)

    {

       size = read(fd, &utmp, sizeof(struct utmp));

       while ( size == sizeof(struct utmp) )

       {

          if ( tty ? ( !strcmp(utmp.ut_line, argv[1]) ) :

            ( !strcmp(utmp.ut_name, argv[1]) ) )

          {

             lseek( fd, -sizeof(struct utmp), L_INCR );

             bzero( &utmp, sizeof(struct utmp) );

             write( fd, &utmp, sizeof(struct utmp) );

          }

          size = read( fd, &utmp, sizeof(struct utmp) );

       }

    }

    close(fd);

}

