/*
 * stack.c:
 * Written by BJ Bell Copyright(c) 1997
 *
 * stack handeling routines
*/

#include "stack.h"

/* 'A' is a struct stack */
#define STACK_EMPTY(A) (!((A)->top))		/* is stack empty? */		
#define STACK_FULL(A) ((A)->top == STACK_SIZE) 	/* is stack full? */

void init_stack(struct stack *);
int push_stack(char *,struct stack *);
char *pop_stack(struct stack *);

/* 
 * initialize the stack cells to nullstr and set the top of the stack
 * to zero.
*/

void init_stack(struct stack *stack_ptr) {

	int i;

	for(i = 0;i < STACK_SIZE;i++)
		strcpy(stack_ptr->se[i],nullstr);
	stack_ptr->top = 0;
}

/* 
 * make sure you check the string size *BEFORE* you try to push it 
 * onto the stack. 
*/

int push_stack(char *str,struct stack *stack_ptr) {

	if(!STACK_FULL(stack_ptr)) {

		strcpy(stack_ptr->se[(stack_ptr->top)++],str);
		return(TRUE);
	}
	else
		return(FALSE);
}

char *pop_stack(struct stack *stack_ptr) {
	
	if(!STACK_EMPTY(stack_ptr)) 
		return(stack_ptr->se[--stack_ptr->top]);
	else 
		return(nullstr);
}
		
