#!/bin/sh
#rpc.chk 1.0
#
# Make sure you have got a newer version of Bourne Shell (SVR2 or newer)
# that supports functions. It's usually located in /bin/sh5 (under ULTRIX OS)
# or /bin/sh (Sun OS, RS/6000 etc) If it's located elsewhere, feel free to
# change the magic number, indicating the type of executable Bourne Shell.
#
# The script obtains via nslookup utility a list of hostnames from a nameserver
# and checks every entry of the list for active rexd procedures as well as
# ypserver procedures. The output is a list of the sites that run those
# daemons and are insecure.
# -yo.


domainname=$1
umask 022
PATH=/bin:/usr/bin:/usr/ucb:/usr/etc:/usr/local/bin ; export PATH

#
# Function collects a list of sites
# from a nameserver. Make sure you've got the nslookup utility.
#
get_list() {
(
echo set type=ns
echo $domainname
) | nslookup | egrep "nameserv" | cut -d= -f2> .tmp$$  2>/dev/null
if [ ! -s .tmp$$ ]; then
echo "No such domain" >&2
echo "Nothing to scan" >&2
exit 1
fi
for serv in `cat .tmp$$`;do
(
echo server $serv
echo ls  $domainname
) | nslookup > .file$$ 2>/dev/null
lines=`cat .file$$ | wc -l`
tail -`expr $lines  - 7` .file$$  | cut -d" " -f2 > .file.tmp # .file
sed -e "s/$/.$domainname/"  .file.tmp > .hosts$$
rm -rf .file* .tmp$$
sort .hosts$$ | uniq -q >> HOSTS$$; rm -rf .hosts$$
done
tr 'A-Z' 'a-z' <HOSTS$$ |sort|uniq -q > HOSTS.$domainname;rm -rf HOSTS$$
}

# Function

rpc_calls()
{
for entry in `cat HOSTS.$domainname`; do
(
rpcinfo -t $entry ypserv >/dev/null  && echo $entry runs YPSERV ||  exit 1 # Error!
) >> .log  2>/dev/null
(
rpcinfo -t $entry rex >/dev/null && echo $entry runs REXD ||  exit 1 # Error !
 ) >> .log  2>/dev/null
done
}

# Main

if [ "$domainname" = '' ];  then
echo "Usage $0 domainname" >&2
exit 1
fi
get_list
echo "Checking $domainname domain" > .log
echo "*****************************" >> .log
echo "Totally `cat HOSTS.$domainname | wc -l` sites  to scan" >> .log
echo "******************************" >> .log
echo "started at `date`" >> .log
echo "******************************" >> .log
rpc_calls
echo "******************************" >> .log
echo "finished at `date`"  >> .log


