/*
 * queue.c:
 * Written by BJ Bell Copyright(c) 1997
 *
 * queue handeling routines
*/

#include "queue.h"

void init_q(struct queue *);
int q_full(struct queue *);
int q_empty(struct queue *);
int q_add(char *,struct queue *);
char *q_remove(struct queue *);

void init_q(struct queue *q_ptr) {

	int i;

	for(i = 0;i < Q_SIZE;i++)
		strcpy(q_ptr->qe[i],null_str);

	q_ptr->front = 0;
	q_ptr->back = 0;
}

/*
 * Theres a problem with using circular queues in that its pretty 
 * impossiable to distinguish between a full queue and an empty queue
 * because the wrap around can do strange things where the front and back
 * of a queue are the same. I'm not the best person to explain this so if
 * your confused go read a book! :P Anywho, if you keep a buffer cell 
 * between front and back then everything is ok, but that means you can
 * only get 49 values out of a 50 element queue. 
*/

int q_full(struct queue *q_ptr) {

	/* if the circular queue wraps all the way around to where 
	 * the back is just under the front of the queue (i.e.
         * back == 2 and front == 3) then we know the queue is full.
         * this is what everything before the '||' acomplishes.
	*/

	if((q_ptr->back == q_ptr->front - 1) || 
	
	/* 
	 * this is for a normal full queue where the back is one
	 * less then the queue size and the front is zero. In this
 	 * case there is no wrap around because cells 0 - 49 are full
	*/
	
	((q_ptr->back == Q_SIZE -1) && (q_ptr->front == 0)))
		return(TRUE);	/* the queue is full */
	else
		return(FALSE);	/* the queue is not full */
}

int q_empty(struct queue *q_ptr) {

	/* 
	 * if front and back are equal then we know the
	 * queue is empty. Most likely they will both be 0.
	 * TRUE means the queue is empty, FALSE means its not.
	*/

	return((q_ptr->front == q_ptr->back) ? TRUE : FALSE);
}

int q_add(char *str,struct queue *q_ptr) {

	if(!q_full(q_ptr)) {	/* if queue is not full */

		/* stick it in the back of the queue and increment*/
		strcpy(q_ptr->qe[(q_ptr->back)++],str);
		
		/* 
		 * now to make the queue wrap around when there
		 * are empty cells at the beginning again all you 
  		 * do is use the modulous to set back to where it
		 * should be. For example if we did '46 % Q_SIZE' (50)
		 * the queue does not wrap yet and 46 is returned.
		 * However if we get to '50 % Q_SIZE' (50) then there
		 * is a remainder of 0 and we stuff that value into
		 * back and the queue wraps around back to 0 and starts
		 * over again. 
		*/

		q_ptr->back %= Q_SIZE;
		return(TRUE);	/* addition to queue worked */
	}
	else
		return(FALSE); /* addition to queue didn't work */
}

char *q_remove(struct queue *q_ptr) {

	char *temp;
	temp = (char *)malloc(strlen(q_ptr->qe[q_ptr->front]));

	if(!q_empty(q_ptr)) {	/* if queue is not empty */

		/*
		 * copy the string thats being purged and increment
		 * the front of the queue. Check to see if its time to
		 * wrap front around the same basic way that it was
		 * done in q_add().
		*/

		strcpy(temp,q_ptr->qe[(q_ptr->front)++]);
		q_ptr->front %= Q_SIZE;
		return(temp);	/* return purged string */
	}
	else
		return(null_str);
}
