/*
 * llist.c:
 * Written by BJ Bell Copyright(c) 1997
 *
 * linked list handeling routines.
*/

#include "llist.h"

struct llist *init_node(struct llist *); 
struct llist *add_back(struct llist *, struct llist *);
struct llist *add_front(struct llist *, struct llist *);
struct llist *add_order(struct llist *, struct llist *);
struct llist *del_link(struct llist *,int);

/* initialize the linked list element */

struct llist *init_node(struct llist *element) {

	element = (struct llist *)malloc(sizeof(struct llist));
	if(element != NULL) {

		strcpy(element->data,null_str);
		element->next = NULL;
	}
	else
		fprintf(stderr,"ERROR: malloc()\n");
	return(element);	/* NULL is returned if fail */
}

/* add linked list element to the back of the linked list */

struct llist *add_back(struct llist *new, struct llist *list) {

	if(list == NULL) {
		
		list = new;
		return(list);	/* if list is empty, new is the list */
	}
	else {

		/* call recursively untill end of list is reached */
		/* add new element to the end			  */

		list->next = add_back(new,list->next);
		return(list);
	}
}

struct llist * add_front(struct llist *new, struct llist *list) {

	/* make the new element point to the list, making */
	/* new the front of the list.			  */

	new->next = list;
	list = new;
	return(list);
}

struct llist *add_order(struct llist *new, struct llist *list) {

	if(list == NULL) {

	/* if list is empty, new is the list */

		list = new;
		return(list);
	}
	else if(strcmp(list->data,new->data) > 0) {

	/* if lists's data is greater then news's data    */
	/* then make new point to list. This puts it in a */
	/* least to greatest order.			  */

		new->next = list;
		list = new;
		return(list);
	}
	else {
		/* otherwise, recursively call until you find         */
		/* the above statement that is true, then everything  */
		/* fits into place (The correct order) when execution */
		/* returns to the calling functions.		      */

		list->next = add_order(new,list->next);
		return(list);
	}
}

struct llist *del_link(struct llist *base, int element) {

	struct llist *current, *pred;
	int index;

	current = base;
	pred = NULL;

	/* if the list is empty or a no existing element is passed */
	if((base == NULL) || (element < 0)) 
		return(base);	/* return the list */
	
	/* delete first element */
	if(element == 1) {

		base = base->next;	/* link next element with previous */
		return(base);
	}
	
	if(element) {	/* element other then the first */
	
		/* go to specified element or till end is reached */
		for(index = 1;(index < element) && (current != NULL);index++) {
			
			pred = current;
			current = current->next;
		}
	}
	else if(current->next == NULL) {
		/* if end of list */
		base = NULL;
		return(base);
	}
	else {

		while((current != NULL) && (current->next != NULL)) {

			pred = current;
			current = current->next;
			index++;
		}
	}
	if(pred != NULL) {	/* if element other then first was deleted */
	
		if(current != NULL) {

			current = current->next;
			pred->next = current;
		}
	}
	
	return(base);
}
