#include        "inet.h"
#define MAXLINE 512
#define DEFAULT_IDENT "%d , %d : USERID : UNIX : identsux\n"

/* prototypes */

int
writen(int fd, char *ptr, int nbytes);
int
readline(int fd, char *ptr, int maxlen);



main(argc, argv)
int     argc;
char    *argv[];
{
  int                     sockfd, newsockfd, clilen, childpid,n;
  int clisockfd;
  int localp, remotep;
  struct sockaddr_in      cli_addr, serv_addr;
  char line[MAXLINE];   

  pname = argv[0];

  /*
   * Open a TCP socket (an Internet stream socket).
   */

  if ( (sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    exit(-1);
  /*
   * Bind our local address so that the client can send to us.
   */

  bzero((char *) &serv_addr, sizeof(serv_addr));
  serv_addr.sin_family      = AF_INET;
  serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
  serv_addr.sin_port        = htons(SERV_TCP_PORT);

  if (bind(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0)
    exit(-1);

  listen(sockfd, 5);
  for ( ; ; ) {
    clilen = sizeof(cli_addr);
    newsockfd = accept(sockfd, (struct sockaddr *) &cli_addr,
		       &clilen);
    if (newsockfd < 0)
      exit(-1);

    /* dont fork */
    n = readline(newsockfd, line, MAXLINE);
    if (n < 0)
      exit(-1);
    printf("read: %s\n",line);
    sscanf(line,"%d , %d",&localp,&remotep);
    sprintf(line,"%d , %d",remotep,localp);
    printf("returning: %s\n",line);

    /* start reverse ident lookup... */
    bzero((char *) &serv_addr, sizeof(serv_addr));
    serv_addr.sin_family      = AF_INET;
    serv_addr.sin_addr.s_addr = cli_addr.sin_addr.s_addr;
    serv_addr.sin_port        = htons(SERV_TCP_PORT);

    if ( (clisockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
      {      sprintf(line,DEFAULT_IDENT,localp,remotep); goto barf; }

    if (connect(clisockfd, (struct sockaddr *) &serv_addr,
		sizeof(serv_addr)) < 0) { 
      sprintf(line,DEFAULT_IDENT,localp,remotep); goto barf;
    }
    if (writen(clisockfd, line, n) != n)
      {     
	sprintf(line,DEFAULT_IDENT,localp,remotep); goto barf;
      }
    n = readline(clisockfd, line, MAXLINE);
    if (n<0)  
      sprintf(line,DEFAULT_IDENT,localp,remotep); 

  barf:    
    printf("returning ident: %s",line);
    n = strlen(line);
    if (writen(newsockfd, line, n) != n)
      { }    

    /* clean up connections */
    close(newsockfd);
    close(clisockfd);
  }
}

/*
 * Write "n" bytes to a descriptor.
 * Use in place of write() when fd is a stream socket.
 */

int
writen(fd, ptr, nbytes)
register int	fd;
register char	*ptr;
register int	nbytes;
{
	int	nleft, nwritten;

	nleft = nbytes;
	while (nleft > 0) {
		nwritten = write(fd, ptr, nleft);
		if (nwritten <= 0)
			return(nwritten);		/* error */

		nleft -= nwritten;
		ptr   += nwritten;
	}
	return(nbytes - nleft);
}
/*
 * Read a line from a descriptor.  Read the line one byte at a time,
 * looking for the newline.  We store the newline in the buffer,
 * then follow it with a null (the same as fgets(3)).
 * We return the number of characters up to, but not including,
 * the null (the same as strlen(3)).
 */

int
readline(fd, ptr, maxlen)
register int	fd;
register char	*ptr;
register int	maxlen;
{
	int	n, rc;
	char	c;

	for (n = 1; n < maxlen; n++) {
		if ( (rc = read(fd, &c, 1)) == 1) {
			*ptr++ = c;
			if (c == '\n')
				break;
		} else if (rc == 0) {
			if (n == 1)
				return(0);	/* EOF, no data read */
			else
				break;		/* EOF, some data was read */
		} else
			return(-1);	/* error */
	}

	*ptr = 0;
	return(n);
}
