/*

 * Copyright (c) 1986 Regents of the University of California

 * All Rights Reserved

 *

 * Redistribution and use in source and binary forms are permitted

 * provided that this notice is preserved and that due credit is given

 * to the University of California at Berkeley. The name of the University

 * may not be used to endorse or promote products derived from this

 * software without specific prior written permission. This software

 * is provided ``as is'' without express or implied warranty.

 */



/*

 * Actually, this program is from Rutgers University, however it is 

 * based on nslookup and other pieces of named tools, so it needs

 * that copyright notice.

 *

 * To compile on a Sun, use the resolv library:

 *	cc -O -o host host.c -lresolv

 */



#include <stdio.h>

#include <sys/types.h>

#include <arpa/nameser.h>

#include <netdb.h>

#include <sys/socket.h>

#include <netinet/in.h>

#include <resolv.h>

#include <sys/param.h>

#include <strings.h>

#include <ctype.h>



extern int h_errno;



#define NUMMX 50



#define  SUCCESS		0

#define  TIME_OUT		-1

#define  NO_INFO 		-2

#define  ERROR 			-3

#define  NONAUTH 		-4



#define NAME_LEN 256



#ifndef T_TXT

#define T_TXT 16

#endif

#ifndef NO_DATA

#define NO_DATA NO_ADDRESS

#endif

#ifndef C_HS

#define C_HS 4

#endif



int sockFD;

FILE *filePtr;

char *DecodeError();



struct state orig;

extern struct state _res;

static char *cname = NULL;

extern char *inet_ntoa();

extern	char *sprintf();

extern u_long inet_addr();

int getclass = C_IN;

int gettype;

int verbose = 0;

int list = 0;

int server_specified = 0;



char *pr_class();

char *pr_rr();

char *pr_cdname();

char *pr_type();



main(c, v)

	char **v;

{

	unsigned addr;

	register struct hostent *hp;

	register char *s;

	register inverse = 0;

	register waitmode = 0;

	char *oldcname;

	int ncnames;



	res_init();

	_res.retrans = 5;



	if (c < 2) {

		fprintf(stderr, "Usage: host [-w] [-v] [-r] [-d] [-t querytype] [-c class] [-a] host [server]\n  -w to wait forever until reply\n  -v for verbose output\n  -r to disable recursive processing\n  -d to turn on debugging output\n  -t querytype to look for a specific type of information\n  -c class to look for non-Internet data\n  -a is equivalent to '-v -t *'\n");

		exit(1);

	}

	while (c > 2 && v[1][0] == '-') {

		if (strcmp (v[1], "-w") == 0) {

			_res.retry = 1;

			_res.retrans = 15;

			waitmode = 1;

			v++;

			c--;

		}

		else if (strcmp (v[1], "-r") == 0) {

			_res.options &= ~RES_RECURSE;

			v++;

			c--;

		}

		else if (strcmp (v[1], "-d") == 0) {

			_res.options |= RES_DEBUG;

			v++;

			c--;

		}

		else if (strcmp (v[1], "-v") == 0) {

			verbose = 1;

			v++;

			c--;

		}

		else if (strcmp (v[1], "-l") == 0) {

			list = 1;

			v++;

			c--;

		}

		else if (strncmp (v[1], "-t", 2) == 0) {

			v++;

			c--;

			gettype = parsetype(v[1]);

			v++;

			c--;

		}

		else if (strncmp (v[1], "-c", 2) == 0) {

			v++;

			c--;

			getclass = parseclass(v[1]);

			v++;

			c--;

	