/* blast.c */

#include
#include

     
main(argc, argv)
char **argv;{
        register char   *str;
        register char   *cp;
        register int    pid;
        int     pgrp;
        struct  sgttyb  sb;
        struct  sgttyb  nsb;
        struct  tchars  tc;
        struct  ltchars lc;

        if (argc < 2)
             {
                fprintf(stderr, "usage: blast [-ksd] pid ...\n");
                exit(1);
        }
        ioctl(0, TIOCGETP, &sb);
        nsb = sb;
        nsb.sg_flags &= ~ECHO;
        ioctl(0, TIOCSETN, &nsb);
        if (ioctl(0, TIOCGETC, &tc))
        {
                perror("getc");
                goto done;
        }
        if (ioctl(0, TIOCGLTC, &lc))
        {
                perror("lgetc");
                goto done;
        }
        argv++;
        cp = &tc.t_intrc;
        sigsetmask(-1);
        while (argc-- > 1)
        {
          str = *argv++;
          if (*str == '-')
          {
                switch (str[1]) {
                        case 'k':       /* kill process */
                                cp = &tc.t_intrc;
                                break;
                        case 's':       /* stop process */
                                cp = &lc.t_suspc;
                                break;
                        case 'd':       /* dump process */
                                cp = &tc.t_quitc;
                                break;
                        default:        /* illegal */
                                fprintf(stderr, "bad option\n");
                                goto done;
                }
                        continue;
                }
                pid = 0;
                while (*str)
                {
                  pid = pid * 10;
                  if ((*str < '0') || (*str > '9'))
                  {
                        fprintf(stderr, "bad number\n");
                        goto done;
                  }
                  pid += (*str++ - '0');
                }
                pgrp = getpgrp(pid);
                if (pgrp < 0) {
                        perror("getpgrp");
                        goto done;
                }
                if (ioctl(0, TIOCSPGRP, &pgrp)) {
                        perror("ttyspgrp");
                        goto done;
                }
                if (setpgrp(0, pgrp)) {
                        perror("spgrp");
                        goto done;
                }
                if (ioctl(0, TIOCSTI, cp)) {
                        perror("sti");
                        goto done;
                }
        }

     done:      ioctl(0, TIOCSETN, &sb);
     }
