/* ipl.c 1/3/95    by loq */
/* monitors ip packets for Linux */
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <linux/if.h>
#include <signal.h>
#include <stdio.h>
#include <linux/socket.h>
#include <linux/ip.h>
#include <linux/tcp.h>
#include <linux/if_ether.h>

#define BUFLEN 8192
#define ETHLINKHDR 14


print_data(int count, char *buff)
{
	int i,j,c;
	int printnext=1;
	if(count)
	{
	if(count%16)
		c=count+(16-count%16);
	else c=count;
	}
		else
		c=count;
	for(i=0;i<c;i++)
	{
		if(printnext) { printnext--; printf("%.4x ",i&0xffff); }
		if(i<count)
		printf("%3.2x",buff[i]&0xff);
		else
		printf("   ");
		if(!((i+1)%8)) 
			if((i+1)%16)
				printf(" -");
			else
				{
					printf("   ");
					for(j=i-15;j<=i;j++)
					  if(j<count) {
						if( (buff[j]&0xff) >= 0x20 && 
						    (buff[j]&0xff)<=0x7e)
						      printf("%c",buff[j]&0xff);
						else printf(".");
						} else printf(" ");
				printf("\n"); printnext=1;
				}
	}
}

int
initdevice(device, pflag)
	char *device;
	int pflag;
{
#define PROTO htons(0x0800)   /* Ethernet code for IP protocol */

	int if_fd=0;
	struct ifreq ifr;

	if ( (if_fd=socket(AF_INET,SOCK_PACKET,PROTO)) < 0 ) {
		perror("Can't get socket");
		exit(2);
	}

	strcpy(ifr.ifr_name, device);       /* interface we're gonna use */
	if( ioctl(if_fd, SIOCGIFFLAGS, &ifr) < 0 ) {    /* get flags */
		close(if_fd);
		perror("Can't get flags");
		exit(2);
	}
#if 1
	if ( pflag )
		ifr.ifr_flags |= IFF_PROMISC;         /* set promiscuous mode */
	else
		ifr.ifr_flags &= ~(IFF_PROMISC);
#endif

	if( ioctl(if_fd, SIOCSIFFLAGS, &ifr) < 0 ) {    /* set flags */
		close(if_fd);
		perror("Can't set flags");
		exit(2);
	}
	return if_fd;
}

struct etherpacket {
	struct ethhdr		eth;	
	struct iphdr		ip;
	struct tcphdr		tcp;
	char			data[8192];
	};

main()
{
	int linktype;
	int if_eth_fd=initdevice("eth0",1);
#if 0
	int if_ppp_fd=initdevice("sl0",1);
#endif
	struct etherpacket ep;
	struct sockaddr dest;
	struct iphdr *ip;
	struct tcphdr *tcp;
	struct timeval timeout;
	fd_set rd,wr;
	int dlen;
#if 0
	struct slcompress *slc=slhc_init(64,64);	
#endif

	for(;;)
	{
		bzero(&dest,sizeof(dest));
		dlen=0;
		FD_ZERO(&rd);
		FD_ZERO(&wr);
		FD_SET(if_eth_fd,&rd);
#if 0
		FD_SET(if_ppp_fd,&rd);
#endif
		timeout.tv_sec=0;
		timeout.tv_usec=0;
		ip=(struct iphdr *)(((unsigned long)&ep.ip)-2);
		tcp=(struct tcphdr *)(((unsigned long)&ep.tcp)-2);
		while(timeout.tv_sec==0 && timeout.tv_usec==0)
		{
		timeout.tv_sec=10;
		timeout.tv_usec=0;
		select(20,&rd,&wr,NULL,&timeout);
		if(FD_ISSET(if_eth_fd,&rd))
			{
			printf("eth\n");
			recvfrom(if_eth_fd,&ep,sizeof(ep),0,&dest,&dlen);
			}
#if 0
		else
			if(FD_ISSET(if_ppp_fd,&rd))
			{
			recvfrom(if_ppp_fd,&ep,sizeof(ep),0,&dest,&dlen);
			printf("ppp\n");
			}
#endif
		}	

		printf("proto: %.4x",ntohs(ep.eth.h_proto));
#if 0
		if(ep.eth.h_proto==ntohs(8053))
		{
			slhc_uncompress(slc,&ep,sizeof(ep));
		}
#endif

		if(ep.eth.h_proto==ntohs(ETH_P_IP))
		{
		printf("%.2x:%.2x:%.2x:%.2x:%.2x:%.2x->",
			ep.eth.h_source[0],ep.eth.h_source[1],
			ep.eth.h_source[2],ep.eth.h_source[3],
			ep.eth.h_source[4],ep.eth.h_source[5]);
		printf("%.2x:%.2x:%.2x:%.2x:%.2x:%.2x ",
			ep.eth.h_dest[0],ep.eth.h_dest[1],
			ep.eth.h_dest[2],ep.eth.h_dest[3],
			ep.eth.h_dest[4],ep.eth.h_dest[5]);
		printf("%s[%d]->",inet_ntoa(ip->saddr),ntohs(tcp->source));
		printf("%s[%d]\n",inet_ntoa(ip->daddr),ntohs(tcp->dest));
		print_data(htons(ip->tot_len)-sizeof(ep.ip)-sizeof(ep.tcp),
			ep.data-2);
		}
	}
}
